SELECT 
    PS_PARTKEY, 
    SUM(PS_SUPPLYCOST * PS_AVAILQTY) AS VALUE
FROM 
    PARTSUPP, 
    SUPPLIER, 
    NATION
WHERE 
    PS_SUPPKEY = S_SUPPKEY 
    AND S_NATIONKEY = N_NATIONKEY 
    AND N_NAME = 'GERMANY'
GROUP BY 
    PS_PARTKEY
HAVING 
    SUM(PS_SUPPLYCOST * PS_AVAILQTY) > TOTAL_VALUE()
ORDER BY 
    VALUE DESC NULLS LAST;